/* ===================== TFunctions ======================================= */
BaseFloatType T_Null(BaseFloatType inp, BaseFloatType weight)
{							/* Input &  Output */
    return inp;
}
BaseFloatType T_Sin(BaseFloatType inp, BaseFloatType weight)
{
    return 2*inp-1;
}
BaseFloatType T_Std(BaseFloatType inp, BaseFloatType weight) 
{								/* Standart */
    return (inp*weight);
}
/* ===================== InFunctions ====================================== */
BaseFloatType In_SumStd(unsigned int Num, BaseFloatType *Inp) 
{								/* Standart */
    BaseFloatType Res=0;
    for (unsigned i=0;i<Num;i++)
	Res+=Inp[i];
    return Res;
}
/* ===================== OutFunctions ===================================== */
BaseFloatType Out_ExpStdNW(BaseFloatType inp, BaseFloatType weight)
{								/* Standart */
    return 1/(1+exp(-inp));
}
BaseFloatType Out_Sin(BaseFloatType inp, BaseFloatType weight)
{
    return 2/(1+exp(-inp))-1;
}
BaseFloatType Out_SinP(BaseFloatType inp, BaseFloatType weight)
{
    return 2/(1+exp(-inp-weight))-1;
}
BaseFloatType Out_ExpStdNWP(BaseFloatType inp, BaseFloatType weight)
{								/* Ani Standart */
    return 1/(1+exp(-inp-weight));
}
BaseFloatType Out_ExpStdNWPOut(BaseFloatType inp, BaseFloatType weight)
{
    BaseFloatType a=1/(1+exp(-inp-weight));
    if (a<0.45) return 0;
    else return 1;
}
BaseFloatType Out_Null(BaseFloatType inp, BaseFloatType weight)
{
    return inp;
}
BaseFloatType Out_Nop(BaseFloatType inp, BaseFloatType weight)
{
    return 1/inp;
}
/* ===================== Quality Minor Function ============================ */
BaseFloatType Qi_Disp2Std(BaseFloatType *Input, BaseFloatType *Output)
{								/* Standart */
    BaseFloatType Res=0;
    for (unsigned i=0;i<*lkOut;i++)
	Res+=pow(Output[i]-Input[*lkIn+i],2);
    return Res;
}
BaseFloatType Qi_DispStd(BaseFloatType *Input, BaseFloatType *Output)
{								/* Standart */
    BaseFloatType Res=0;
    for (unsigned i=0;i<*lkOut;i++)
	Res+=fabs(Output[i]-Input[*lkIn+i]);
    return Res;
}
BaseFloatType Qi_Ani1(BaseFloatType *Input, BaseFloatType *Output)
{					/* Especial for Chilin's ANI 
					First Problem with 1 boolean Output */
    if (Output[0]==0) return 0;
    else if (Input[*lkIn]==1) return 1;
    else return 2;
}

BaseFloatType Qi_Classify(BaseFloatType *Input, BaseFloatType *Output)
{
    if (Output[0]<0.33)
    {
	if (Input[*lkIn]<0.33) return 0;
	else if (Input[*lkIn]<0.66) return 1;
	else return 1;
    }
    else if (Output[0]<0.66)
    {
	if (Input[*lkIn]<0.33) return 1;
	else if (Input[*lkIn]<0.66) return 0;
	else return 1;
    }
    else
    {
	if (Input[*lkIn]<0.33) return 1;
	else if (Input[*lkIn]<0.66) return 1;
	else return 0;
    }
}
/* ===================== Quality Major Function ============================ */
BaseFloatType Qa_SumStd(BaseFloatType *Quality)
{								/* Standart */
    BaseFloatType Res=0;
    for (unsigned long int i=0;i<*lkID;i++)
	Res+=Quality[i];
    return Res;
}

BaseFloatType Qa_SumStdNorm(BaseFloatType *Quality)
{								/* Standart */
    BaseFloatType Res=0;
    for (unsigned long int i=0;i<*lkID;i++)
	Res+=Quality[i];
    Res/=*lkID;
    return Res;
}

BaseFloatType Qa_Ani1(BaseFloatType *Quality)
{					/* Especial for Chilin's ANI 
					First Problem with 1 boolean Output */
    unsigned long int Non=0, Nof=0;
    for (unsigned long int i=0;i<*lkID;i++)
    {
	if (Quality[i]==1) Non++;
	else if (Quality[i]==2) Nof++;
    }
    if (Nof>=Non) return (1e+50);
    return pow(Non+Nof,0.2)/(Non-Nof);
}
BaseFloatType Qa_Ani2(BaseFloatType *Quality)
{					/* Especial for Chilin's ANI 
					First Problem with 1 boolean Output */
    unsigned long int Non=0, Nof=0;
    for (unsigned long int i=0;i<*lkID;i++)
    {
	if (Quality[i]==1) Non++;
	else if (Quality[i]==2) Nof++;
    }
    if (Nof>=Non) return (1e+50);
//    printf("-> %u %u\n",Non,Nof);
    return 1./(Non-Nof);
}
/* ------------------------------------------------------------------------ */