/*
 * Testprogram to communicate with the camera.
 *
 * test.exe <PropertyName> <Value>         #communicate on default port 0
 * test.exe <Port> <PropertyName> <Value>  #communicate on port Port
 *
 * test.exe			#List all properties of port 0
 * test.exe Window.X		#Get value of Property Window.X on port 0
 * test.exe Window.X 100	#Set value of Property Window.X to 100 on port 0
 *
 * test.exe 1			#List all properties of port 1
 * test.exe 1 Window.X		#Get value of Property Window.X on port 1
 * test.exe 1 Window.X 100	#Set value of Property Window.X to 100 on port 1
 *
 * test.exe 3			#List all properties of port 3
 * test.exe 3 Window.Y		#Get value of Property Window.Y on port 3
 * test.exe 3 Window.Y 150	#Set value of Property Window.Y to 150 on port 3
 *
 * if the first argument is not a number, the communication is opened over default port 0
 *
 * if the first argument is a number, the communication is opend over given port number
 * 
 */



#include <stdio.h>
#include <stdlib.h>
#include "pfcam.h"

void list_children(int port, TOKEN t);
void print_type(int port, TOKEN t);
////////////////////////////////////////////////////////////////////////////
int handleError(error)
{
	const char *s;

	s = pfGetErrorString(error);
	if (error < 0) {
		printf("Error: %s\n", s);
	} else {
		printf("Warning: %s\n", s);
	}
	return error;
}

void list_children(int port, TOKEN t)
{
	TOKEN child;
	child = pfProperty_Select(port, t, t);
	while (child) {
		printf("Has Child: '%s'\n", pfProperty_GetName(port, child));
		child = pfProperty_Select(port, t, child); // iterate to next
	}
}

static unsigned char *g_types[] = {
	(unsigned char*)"Invalid value",
	(unsigned char*)"ROOT NODE",
	(unsigned char*)"Integer",
	(unsigned char*)"Float",
	(unsigned char*)"Boolean",
	(unsigned char*)"Mode",
	(unsigned char*)"Register",
	(unsigned char*)"String",
	(unsigned char*)"Buffer",
	(unsigned char*)"{Struct}",
	(unsigned char*)"{Array}",
	(unsigned char*)"[Command]",
	(unsigned char*)"[Event]"
};

void print_type(int port, TOKEN t)
{
	printf("Type : %s\n", g_types[pfProperty_GetType(port, t)]);
}

static char s_line[] = "----------------------------------------------\n";

int main(int argc, char **argv)
{
	int error, warn, i;
	char data[64];
	char name[50], manu[50];
	char *tmp;
	TOKEN t, root;
	int port, offset, arg;
	int numOfPorts, mBytes, nBytes, version, type;

	numOfPorts = 0;
	offset = 0;
	port = 0;

	//Init PFLib, get number of available port
	pfPortInit(&numOfPorts);
	printf("Number of Ports: %d\n", numOfPorts);

	//List ports	
	for(i=0; i<numOfPorts; i++){
		pfPortInfo(i, manu, &mBytes, name, &nBytes, &version, &type);
		printf("Port %d: Manufacturer: %s, %s", i, manu, name);
		printf(", mBytes %d, nBytes %d, ver. %d, type %d\n", mBytes, nBytes, version, type);
	}
	printf("\n");
	
	//Check if not default port, means "test.exe 5 " -> port 5
	if(argc > 1){
		arg = strtoul(argv[1], &tmp, 10);
		if(!*tmp){
			port = arg;
			offset = 1;
			if(port >= numOfPorts){
				port = 1;
			}
		}
	}

	//show info about port to open
	pfPortInfo(port, manu, &mBytes, name, &nBytes, &version, &type);
	printf("Opening camera on port: Port %d: %s, %s...\n", port, manu, name);
	
	//open port:
	error = pfDeviceOpen(port);
	if(error < 0) {
		handleError(error);
		return -1;
	}
	else {
		warn = error;
	}

	printf("Device opened \n");

	//Check if higher baud rate is supported
	error = pfIsBaudRateSupported(port, 115200);
	if(error == 1){
		error = pfSetBaudRate(port, 115200);
		if(error < 0){
			handleError(error);
			pfDeviceClose(port);
			return 0;
		}
	}
	else{
		error = pfIsBaudRateSupported(port, 57600);
		if(error == 1){
			error = pfSetBaudRate(port, 57600);
			if(error < 0){
				handleError(error);
				pfDeviceClose(port);
				return 0;
			}
		}
	}
	printf(s_line);

	if(argc >= (2+offset)){//get or set value
		//parse propertyname to token
		t = pfProperty_ParseName(port, argv[1+offset]);
		if(t == INVALID_TOKEN) {
			printf("Property not found or bad index\n");
			pfDeviceClose(port);
			return 0;
		}
		else{
			print_type(port, t);
		}
		
		if(argc == 2+offset){//get property
			list_children(port, t);

			error = pfDevice_GetProperty_String(port, t, data, 64);
			if(error < 0){
				handleError(error);
				pfDeviceClose(port);
				return 0;
			}
			else{
				warn = error;
			}
			printf("Value: %s\n", data);
		}
		else if(argc == 3+offset){//Set property
			error = pfDevice_SetProperty_String(port, t, argv[2+offset]);
			if(error){
				handleError(error);
				if(error < 0){
					pfDeviceClose(port);
					return 0;
				}
			}
		}
		else{
			fprintf(stderr, "Wrong number of arguments\n");
		}
	}
	else{//list properties
		root = pfDevice_GetRoot(port);
		list_children(port, root);
	}
	if(warn){
		handleError(warn);
	}
	pfDeviceClose(port);
	return 0;
}
