/*
 * Testprogram to communicate with the camera.
 *
 * test.exe <PropertyName> <Value>         #communicate on default port 0
 * test.exe <Port> <PropertyName> <Value>  #communicate on port Port
 *
 * test.exe			#List all properties of port 0
 * test.exe Window.X		#Get value of Property Window.X on port 0
 * test.exe Window.X 100	#Set value of Property Window.X to 100 on port 0
 *
 * test.exe 1			#List all properties of port 1
 * test.exe 1 Window.X		#Get value of Property Window.X on port 1
 * test.exe 1 Window.X 100	#Set value of Property Window.X to 100 on port 1
 *
 * test.exe 3			#List all properties of port 3
 * test.exe 3 Window.Y		#Get value of Property Window.Y on port 3
 * test.exe 3 Window.Y 150	#Set value of Property Window.Y to 150 on port 3
 *
 * if the first argument is not a number, the communication is opened over default port 0
 *
 * if the first argument is a number, the communication is opend over given port number
 * 
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "fgrab_struct.h"
#include "fgrab_prototyp.h"
#include "fgrab_define.h"

#define DLLNAME "libFullAreaGray8.so"


Fg_Struct *fg           = NULL;

int handleError(error)
{
  const char *s;

  s = Fg_getLastErrorDescription(fg);
  if (error < 0) {
    printf("Error: %s\n", s);
  } else {
    printf("Warning: %s\n", s);
  }
  return error;
}


int parseName(const char *parameter, int *type){
   int token;
   int *res;

   token = -1;
   *type = 0; // Int
   if (strstr(parameter, "FG_WIDTH") == parameter) token = FG_WIDTH;
   if (strstr(parameter, "FG_HEIGHT") == parameter) token = FG_HEIGHT;

   if (strstr(parameter, "FG_REVNR") == parameter) {token = FG_REVNR; *type = 1;}
   if (strstr(parameter, "FG_FRAMESPERSEC") == parameter) {token = FG_FRAMESPERSEC; *type = 1;}

   return(token);
}



static char s_line[] = "----------------------------------------------\n";

int main(int argc, char **argv)
{
	int error, warn, i;
	char data[64];
	char name[50], manu[50];
	char *parameter;
	int t;
	char *tmp;
	int port, offset, arg;
	int numOfPorts, mBytes, nBytes, version, type;
        double value;
	int valueInt;

        int boardNr             = 0;
        int camPort             = PORT_A;

	numOfPorts = 0;
	offset = 0;
	port = 0;

	printf ("CL Framegrabber camera control\n\n");

	//Init PFLib, get number of available port
	numOfPorts = 2; // Each framegrabber has two ports PORT_A / PORT_B 
	printf("Number of Ports: %d\n", numOfPorts);

	//List ports	
	//for(i=0; i<numOfPorts; i++){
	//	pfPortInfo(i, manu, &mBytes, name, &nBytes, &version, &type);
	//	printf("Port %d: Manufacturer: %s, %s", i, manu, name);
	//	printf(", mBytes %d, nBytes %d, ver. %d, type %d\n", mBytes, nBytes, version, type);
	//}
	//printf("\n");
	
	//Check if not default port, means "test.exe 5 " -> port 5
	if(argc > 1){
		arg = strtoul(argv[1], &tmp, 10);
		if(!*tmp){
			port = arg;
			offset = 1;
			if(port >= numOfPorts){
				port = 1;
			}
		}
	}

	//show info about port to open
	//pfPortInfo(port, manu, &mBytes, name, &nBytes, &version, &type);
	printf("Opening camera on port: Board %d, %s\n", boardNr, "PORT_A");
	
	//open port:
	fg = Fg_Init(DLLNAME, boardNr);	
        if(fg == NULL) {
		handleError(-1);
		return -1;
	}

	printf("Device opened \n");
	printf(s_line);

	if(argc >= (2+offset)){//get or set value
		//parse propertyname to token
		parameter = argv[1+offset];
                t = parseName(parameter, &type);

		//t = pfProperty_ParseName(port, argv[1+offset]);
		//if(t == INVALID_TOKEN) {
		//	printf("Property not found or bad index\n");
		//	pfDeviceClose(port);
		//	return 0;
		//}
		//else{
		//	print_type(port, t);
		//}
		
		if(argc == 2+offset){//get property
		        // Framegrabber has only a flat structure?!
			//list_children(port, t);
                        if (type == 0){
			   error = Fg_getParameter(fg,t,&valueInt,camPort);
			   value = valueInt;
			}
			if (type == 1)
                           error = Fg_getParameter(fg,t,&value,camPort);
			if(error < 0){
				handleError(error);
				Fg_FreeGrabber(fg);
				return 0;
			}
			printf("Value: %f\n", value);
		}
		
		else if(argc == 3+offset){//Set property
		        if (type == 0){
			  sscanf(argv[2+offset], "%d", &valueInt);
			  printf("Set property %s = %d\n", parameter, valueInt);
			  error = Fg_setParameter(fg,t ,&valueInt,camPort);
                          valueInt = 0 ;
                          error = Fg_getParameter(fg,t,&valueInt,camPort);
        			printf("New value = %d\n", valueInt);

			}
			if (type == 1){
			  sscanf(argv[2+offset], "%f", &value);
			  error = Fg_setParameter(fg,t ,&value,camPort);
			}
			if(error){
				handleError(error);
				if(error < 0){
					Fg_FreeGrabber(fg);
					return 0;
				}
			}
		}
		
		else{
			fprintf(stderr, "Wrong number of arguments\n");
		}
	}
	else{//list properties
	        // TODO: List all known properties
		printf("Properties:\n");
		printf("Has Child: '%s'\n", "FG_WIDTH");

		//root = pfDevice_GetRoot(port);
		//list_children(port, root);
	}
	Fg_FreeGrabber(fg);
	return 0;
}
