void InitCounter(unsigned char cnt, unsigned char mode)
{
    WrTim(cnt/3, 3, 64*(cnt%3) + 0x30 + 2*mode);
}

void LoadCounter(unsigned short int cnt, unsigned short int data)
{
    WrTim(cnt/3, cnt%3, (unsigned char)(data&0x00FF));
    WrTim(cnt/3, cnt%3, (unsigned char)((data&0xFF00)>>8));
}

void ResetCounters(unsigned short int cn)
{
    unsigned short int i;
    for (i=1;i<=cn;i++) LoadCounter(i, 0xFFFF);
}


void Capture(unsigned char cnt)
{
    WrTim(cnt/3, 3, 64*(cnt%3));
}

unsigned short int DoubleCount(unsigned char cnt)
{
	  unsigned char alo,bhi;
	  Capture(cnt);
          alo = ~RdTim(cnt/3, cnt%3);
          bhi = ~RdTim(cnt/3, cnt%3);
	  return alo+(((unsigned short int)bhi)<<8);
}

void ProcTIMERS()
{
    unsigned char NewGateFlag=0; 
    unsigned char OldGateFlag;
    unsigned int j;		// Counter
    char *dattim;		// Current time
	// Waiting next read time
/*
    do {
	OldGateFlag = NewGateFlag;
	NewGateFlag = Gateon();
	if ((!OldGateFlag)&&(NewGateFlag)) Strobe();
	Server();
    } while (getseconds()%tint);
*/    
    printf("%lu:%lu\n",getminutes(),getseconds());
        
    StartGate();
    dattim=longtime();
    NewGateFlag=0;
	// Waiting data ready
    do {
	OldGateFlag = NewGateFlag;
	NewGateFlag = Gateon();
	if ((!OldGateFlag)&&(NewGateFlag)) Strobe();
	Server();
    } while ((!OldGateFlag)||(NewGateFlag));
    printf("%lu:%lu\n",getminutes(),getseconds());
        

	// Reading data
    for (j=0;j<nch;j++)
	dbuf[BufPos][j+11]=DoubleCount(j+1);
    ResetCounters(nch); 

    free(tbuf[BufPos]);
    tbuf[BufPos] = dattim;
    
    	// Now we are free to do anything till next read time
}
