/*
 *  Copyright (C) 2004 McMCC <mcmcc@mail.ru>
 *
 *  Support check archives RAR v.3.x
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
static char const rcsid[] = "$Id: unrarlib.c,v 1.0 2004/10/20 18:18:46 mcmcc Exp $";

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/param.h>
#include <libunrar3/dll.hpp>
#include "clamav.h"
#include "others.h"
#include "unrarlib.h"
#include "mbox.h"
#include "blob.h"

int cli_unrar3(const char *dir, int desc)
{

    struct RAROpenArchiveDataEx OpenArchiveData;
    struct RARHeaderData HeaderData;
    int iReadHeaderCode, iProcessFileCode, fd, s_buff;
    char buff[4096], uname[48];
    const char *tmpdir;
    HANDLE hArcData;
    FILE *out;

    if((tmpdir = getenv("TMPDIR")) == NULL)
#ifdef P_tmpdir
        tmpdir = P_tmpdir;
#else
        tmpdir = "/tmp";
#endif

    sprintf(uname, "%s/rarXXXXXX", tmpdir);

    if((fd = mkstemp(uname)) < 0 || (out = fdopen(fd, "w+")) == NULL)
    {
	
	cli_dbgmsg("cli_unrar3: can't generate temporary file %s or open descriptor %d.\n", 
		    uname, fd);
	if(fd >= 0)
	    close(fd);
	unlink(uname);
	return CL_ETMPFILE;
    }	

    while((s_buff=read(desc, buff, sizeof(buff))) > 0) 
    {    
    	if(fwrite(buff, 1, s_buff, out) != s_buff)
	{
	    cli_dbgmsg("cli_unrar3: can't write to file %s.\n", uname); 
	    fclose(out);
	    close(fd);
	    unlink(uname);
	    return CL_EOPEN;
	}
    }
    fclose(out);
    close(fd);
    
    memset(&OpenArchiveData, 0, sizeof(OpenArchiveData));
	
    OpenArchiveData.ArcName         = uname; /* name arch */
    OpenArchiveData.CmtBuf          = NULL;
    OpenArchiveData.OpenMode        = RAR_OM_EXTRACT;
		    
    hArcData = RAROpenArchiveEx(&OpenArchiveData);
			
    if (OpenArchiveData.OpenResult != 0)
    {
        cli_dbgmsg("cli_unrar3: error archive open (%d)\n", OpenArchiveData.OpenResult);
	unlink(uname);
        return CL_EOPEN;
    }
						    
    HeaderData.CmtBuf = NULL;
									
    while ((iReadHeaderCode = RARReadHeader(hArcData, &HeaderData)) == 0)
    {
        iProcessFileCode = RARProcessFile(hArcData, RAR_EXTRACT, (char *)dir, NULL);
        if (iProcessFileCode != 0)
	{
            cli_dbgmsg("cli_unrar3: error archive extract (%d)\n", iProcessFileCode);
            break;
	}
		    
    }
					    
    RARCloseArchive(hArcData);
    unlink(uname);
    
    /*
    if (iProcessFileCode == ERAR_BAD_DATA)
	return CL_ERAR;
    */
    return CL_CLEAN;
}
